(define/contract (bicycle-yield-positions terrain)
  (-> (listof (listof exact-integer?)) (listof (listof exact-integer?)))
  (let* ([m (length terrain)]
         [n (if (zero? m) 0 (length (car terrain))])
    (define (valid? x y) (and (>= x 0) (< x m) (>= y 0) (< y n)))
    (define (height x y) (list-ref (list-ref terrain x) y))
    (define directions '((1 0) (-1 0) (0 1) (0 -1)))
    (define visited (make-hash))
    (define queue (make-queue))
    (for ([i (in-range m)])
    (for ([j (in-range n)])
    (enqueue! queue (list i j (height i j) 1))
    (hash-set! visited (list i j 1) #t))
    (let loop ()
      (if (queue-empty? queue)
          '()
          (let-values ([(x y h s) (apply values (dequeue! queue))])
            (for ([dir directions])
              (let* ([nx (+ x (first dir))]
                     [ny (+ y (second dir))]
                     [ns (if (> (height x y) (height nx ny)) s (add1 s)]))
              (when (and (valid? nx ny) (not (hash-has-key? visited (list nx ny ns))))
                (hash-set! visited (list nx ny ns) #t)
                (enqueue! queue (list nx ny (height nx ny) ns)))))
            (if (zero? s)
                (cons (list x y) (loop))
                (loop))))))